; Diagnostic ROM part 4
; Test 4 CRC2
; Author Dwight Elvey
;
; Converted to standard assembler Hans Otten, 2025
;
; Standard Defines KIM-1
;
; I/O in 6530-002
;
SAD     =     $1740             ; 6530 A DATA
PADD    =     $1741             ; 6530 A DATA DIRECTION
SBD     =     $1742             ; 6530 B DATA
PBDD    =     $1743             ; 6530 B DATA DIRECTION
CLK1T   =     $1744             ; DIV BY 1 TIME
CLK8T   =     $1745             ; DIV BY 8 TIME
CLK64T  =     $1746             ; DIV BY 64 TIME
CLKKT   =     $1747             ; DIV BY 1024 TIME
CLKRDI  =     $1747             ; READ TIME OUT BIT
CLKRDT  =     $1746             ; READ TIME
;
;
; I/O in 6530-002
;
SAD1     =     $1700             ; 6530 A DATA
PADD1    =     $1701             ; 6530 A DATA DIRECTION
SBD1     =     $1702             ; 6530 B DATA
PBDD1    =     $1703             ; 6530 B DATA DIRECTION
CLK1T1   =     $1704             ; DIV BY 1 TIME
CLK8T1   =     $1705             ; DIV BY 8 TIME
CLK64T1  =     $1706             ; DIV BY 64 TIME
CLKKT1   =     $1707             ; DIV BY 1024 TIME
CLKRDI1  =     $1707             ; READ TIME OUT BIT
CLKRDT1  =     $1706             ; READ TIME

; Zero page 6530--002
;
;
TEMP	= 	  $F8
INH     =     $F9               ; INPUT BUFFER
POINTL  =     $FA               ; LSB OF OPEN CELL
POINTH  =     $FB               ; MSB OF OPEN CELL
CNT		=	  $FC				; counter
;
; KIM-1 Routines
;
SCANDS  = $1F1F
KEYIN   = $1F40
GETKEY  = $1F6A

; Test 4 CRC2
;  Switch setting:
;  s6 on
;  --
;  S0 on
;  S1 on
;  S2 off
;  S3 on
;This test the ROM data for -002. It will flash the CRC generated
;from reading the entire ROM. It should read C219. It does this
;in a continuous loop. That is why the CRC flashes, because
;it is rerunning the CRC code and not updating the CRC.
;Any erratic value could be an indication of ROM failue.
; 

; This does a CRC of the -002 ROM image.
; A good CRC is B85A
; This expect a working CRC
; The CRC is flashed onto the CRC as b85A.
; 
; Note that if run on a KIM-1 clone the checksum may be different.
; since most KIM-1 clome designers use a KIM-1 ROM with $FF as filler!
;


	.ORG $0C00
TABLE					;  7 segment for hex numbers
        .byte $BF
        .byte $86
        .byte $DB
        .byte $CF
        .byte $E6
        .byte $ED
        .byte $FD
        .byte $87
        .byte $FF
        .byte $EF
        .byte $F7
        .byte $FC
        .byte $B9
        .byte $DE
        .byte $F9
        .byte $F1
		
CRC					; calculate checksum
		  EOR  $00  	; add byte to checksum
;		
          STA $00
          LSR A
          LSR A
          LSR A
          LSR A
          TAX
          ASL A
          EOR $01
          STA $01
          TXA
          EOR $00
          STA $00
          ASL A
          ASL A
          ASL A
          TAX
          ASL A
          ASL A
          EOR $00
          TAY
          TXA
          ROL A
          EOR $01
          STA $00
          STY $01
          RTS
		  
DISPCRC   LDX #$0F
          LDY #$04
LOOP      LDA $0005,Y
          STY $05
          TAY
          LDA TABLE,Y
          LDY #$00			; init RRIOT Ports
          STY $1740
          STX $1742
          STA $1740
          LDY #$FF			; delay
LY		  NOP
          NOP
          NOP
          NOP
          NOP
          NOP
          NOP
          NOP
          DEY
          BNE LY
          DEX
          DEX
          LDY $1740
          LDY $05
          DEY
          BNE LOOP
          RTS
RESET		  
          LDX #$FF			; first digit and hold TTY out with PA0
          TXS
          LDX #$7F			; init RRIOT port
          STX $1741
          LDX #$00
          STX $1740
          LDX #$1F
          STX $1743
          LDX #$01
          STX $1742
          CLD
          LDA #$FF
          STA $00
          STA $01
          LDA #$00
          STA $02
          LDA #$1C			; Start address KIM-1 6530-002 $1C00
          STA $03
          LDX #$04
          LDY #$00
L108F     STX $04
L1091     STY $05
          LDA ($02),Y		; load byte from ROM 002
          JSR CRC			; show it
          LDY $05
          INY
          BNE L1091
          LDX $02			; next byte
          INX
          STX $02
          LDX $04
          DEX
          BNE L108F
          LDA $00
          AND #$0F
          STA $07
          LDA $00
          AND #$F0
          LSR A
          LSR A
          LSR A
          LSR A
          STA $06
          LDA $01
          AND #$0F
          STA $09
          LDA $01
          AND #$F0
          LSR A
          LSR A
          LSR A
          LSR A
          STA $08
          JSR DISPCRC
          JMP RESET
 
;
HEREV
		.FILL (VECTOR - HEREV)&$FFF, 0
		  .ORG $FFFA
VECTOR		  


;
; Reset vectors
;	

          .BYTE RESET&255
          .BYTE RESET/256
          .BYTE RESET&255
          .BYTE RESET/256
          .BYTE RESET&255
          .BYTE RESET/256
		 .END